/*
  access to donald dick's registry values
  written by alexander yaworsky
  '99
*/

//#define TEST

#include <windows.h>
#include "crc.h"
#include "des.h"
#include "stdlib.h"
#include "paths.h"
#include "registry.h"
#include "stringlist.h"
#include "syslog.h"
#include "toolhelp.h"
#include "switches.h"


/*
  Since 1.53a5 Donald Dick no longer have any predefined name (file names
  and event name).
  All names are stored in generated executable file as resources.
  But there's a problem installing server over existing installation
  - installer must have an opportunity to find existing installation.
  For that purpose we write identification data in registry as default
  value of subkeys under some keys.
*/

static char Alphabet[ 64 ] = { 'A','B','C','D','E','F','G','H','I','J','K','L',
                               'M','N','O','P','Q','R','S','T','U','V','W','X',
                               'Y','Z','0','1','2','3','4','5','6','7','8','9',
                               '.','!','@','#','$','%','^','&','\t','(',')','_',
                               '+','-','=','/',' ','\\','|','[',']','~',':',';',
                               '"','{','}', 0 };

static char* RegIdKeysW95[] = { // keys that contain subkeys with identification
      "System\\CurrentControlSet\\control\\keyboard layouts",
      "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Time Zones"
    };

#define REGIDKEYS_SZ (sizeof(RegIdKeysW95)/sizeof(RegIdKeysW95[0]))

static char* RegIdKeysWNT[ REGIDKEYS_SZ ] = {
      "System\\CurrentControlSet\\control\\keyboard layouts",
      "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Time Zones"
    };

static char        DesKey[8] = { '&','?','.','X','~','S','0',',' };

static HANDLE      RegMutex;
static char**      RegIdKeys;
static STRINGLIST  RegIdSubkeys[ REGIDKEYS_SZ ];
static BOOL        RegIdValidSubkeys[ REGIDKEYS_SZ ];


// characters, placed first in strings to indicate what subkey contains:

#define EMPTY_VALUE        '0'
#define UNKNOWN_VALUE      '1'
#define ID_DATA_VALUE      '2'
#define NEW_ID_DATA_VALUE  '3'

#define MAX_ID_DATA_SZ  512


static void Put6Bits( int Code, char* Buf, int BitIdx )
/*
  put 6-bit code into buffer
*/
  {
    int  Byte;

    Byte = BitIdx >> 3;
    BitIdx &= 7;
    if( BitIdx == 0 ) {
      Buf[ Byte ] = (char) (Code << 2);
    }
    else if( BitIdx <= 2 ) {
      Buf[ Byte ] += (char) (Code << (2 - BitIdx));
    }
    else {
      Buf[ Byte ] += (char) (Code >> (BitIdx - 2));
      Buf[ Byte + 1 ] = (char) (Code << (10 - BitIdx));
    }
  }

static int Get6Bits( char* Buf, int BitIdx )
/*
  get 6-bit code from buffer
*/
  {
    int  Byte, Code;

    Byte = BitIdx >> 3;
    BitIdx &= 7;
    if( BitIdx <= 2 ) {
      Code = ((UCHAR) Buf[ Byte ]) >> (2 - BitIdx);
    }
    else {
      Code = (Buf[ Byte ] << (BitIdx - 2))
             + (Buf[ Byte + 1 ] >> (10 - BitIdx));
    }
    return Code & 63;
  }

static int StringToBytes( char* String, char* Bytes )
/*
  performs 6->8 transformation (6 significant bits to 8 significant bits)
  string must contain symbols a-z, A-Z, 0-9, _ and !
  result is 6-bit strip, padded to byte
  returns size of result
*/
  {
    int  i, Code, SSz, BSz, DstBit;

    SSz = lstrlen( String );
    BSz = (6 * SSz) >> 3;
    if( BSz > MAX_ID_DATA_SZ - 1 ) return -1;
    DstBit = 0;
    for( i = 0; i < SSz; i++ ) {
      Code = ((int) String[i]) & 255;
      if( Code >= '0' && Code <= '9' ) Code -= '0';
      else if( Code >= 'A' && Code <= 'Z' ) Code -= 'A' - 10;
      else if( Code >= 'a' && Code <= 'z' ) Code -= 'a' - 36;
      else if( Code == '_' ) Code = 62;
      else if( Code == '!' ) Code = 63;
      else return -1;
      Put6Bits( Code, Bytes, DstBit );
      DstBit += 6;
    }
    return BSz;
  }

static BOOL StringToBytesA( char* String, char* Bytes, DWORD* BitIndex )
/*
  performs 6->8 transformation (6 significant bits to 8 significant bits)
  string must contain symbols listed in Alphabet
  result is 6-bit strip, truncated to byte
  returns false if DataSz < MAX_ID_DATA_SZ * 8 or string contains inv. chars
*/
  {
    int   i, Code;

    do {
      Code = ((int) *String) & 255; String++;
      Code = (int) CharUpper( (char*) Code );
      for( i = 0; i < 64; i++ ) if( Alphabet[ i ] == (char) Code ) break;
      if( i >= 64 ) {
        SysLog( "StringToBytesA: symbol '%c' (%02X) isn't valid", Code, Code );
        return FALSE;
      }
      if( *BitIndex > MAX_ID_DATA_SZ * 8 - 6 ) return FALSE;
      Put6Bits( i, Bytes, *BitIndex );
      *BitIndex += 6;
    } while( Code != 0 );
    return TRUE;
  }

static BOOL BytesToString( char* Bytes, int Sz, char* String )
/*
  performs 8->6 transformation (8 significant bits to 6 significant bits)
  string will contain symbols a-z, A-Z, 0-9, _ and !
  returns false if string is longer than MAX_ID_DATA_SZ
*/
  {
    int  Bit, i, Ch;

    Sz <<= 3;
    Bit = 0;
    i = 0;
    while( Bit < Sz ) {
      Ch = Get6Bits( Bytes, Bit );
      if( i >= MAX_ID_DATA_SZ - 1 ) {
        String[ i ] = '\0';
        return FALSE;
      }
      if( Ch < 10 ) Ch += '0';
      else if( Ch < 36 ) Ch += 'A' - 10;
      else if( Ch < 62 ) Ch += 'a' - 36;
      else if( Ch == 62 ) Ch = '_';
      else Ch = '!';
      String[ i++ ] = (char) Ch;
      Bit += 6;
    }
    String[ i ] = '\0';
    return TRUE;
  }

static BOOL BytesToStringA( char* Bytes, int Sz, char* String )
/*
  performs 8->6 transformation (8 significant bits to 6 significant bits)
  string will contain symbols listed in Alphabet
  returns false if string is longer than MAX_ID_DATA_SZ
*/
  {
    int  Bit, i, Ch;

    Sz = Sz << 3;
    Bit = 0;
    i = 0;
    while( Bit < Sz ) {
      Ch = Get6Bits( Bytes, Bit );
      if( i >= MAX_ID_DATA_SZ - 2 ) {
        String[ i ] = '\0';
        String[ i + 1 ] = '\0';
        return FALSE;
      }
      String[ i++ ] = Alphabet[ Ch ];
      Bit += 6;
    }
    String[ i++ ] = '\0';
    String[ i ] = '\0';
    return TRUE;
  }

static void EncryptValue( char* Buf, int Sz )
  {
    DESDATA  DesCtx;

    CopyMemory( DesCtx.Key, DesKey, 8 );
    DesCtx.Iterations = 16;
    DesCtx.ModeCBC = 1;
    DesInit( &DesCtx );
    DesEncrypt( &DesCtx );
    DesCrypt( &DesCtx, Buf, Sz );
  }

static void DecryptValue( char* Buf, int Sz )
  {
    DESDATA  DesCtx;

    CopyMemory( DesCtx.Key, DesKey, 8 );
    DesCtx.Iterations = 16;
    DesCtx.ModeCBC = 1;
    DesInit( &DesCtx );
    DesDecrypt( &DesCtx );
    DesCrypt( &DesCtx, Buf, Sz );
  }

/*
  Identification data block format:
  id block in string representation
  <id block> encrypted with DES:
  <<data block 1>, <data block 2>,... <data block N>>
  <data block> (length is 8 bytes):
  <filler><data> for the first block filler is crc8 of the rest of id block
  <data> (length is 7 bytes) - strings in 6-bit char representation
  strings:
  server file name
  server exe file name
  loader file name
  acl file name
  registry home key name
  registry value name for data
  registry value name for char
  event name
  empty string (end of data)
*/

static BOOL DecipherIdData( char* Data, LONG* Size )
/*
  deciphers data block and returns true;
  returns false if data block has invalid format
*/
  {
    char     Buf[ MAX_ID_DATA_SZ ];
    int      Sz, i, j;

    Sz = StringToBytes( Data, Buf );
    if( Sz == -1 ) {
      SysLog( "DecipherIdData: StringToBytes failed" );
      return FALSE;
    }
    if( Sz & 7 ) {
      SysLog( "DecipherIdData: bad data size" );
      return FALSE;
    }
    DecryptValue( Buf, Sz );
    if( CalculateCrc8( &Buf[1], Sz - 1 ) != Buf[0] ) {
      SysLog( "DecipherIdData: bad CRC8" );
      return FALSE;
    }
    for( i = j = 0; i < Sz; i += 8, j += 7 )
      RtlMoveMemory( &Buf[ j ], &Buf[ i + 1 ], 7 );
    CopyMemory( Data, Buf, j );
    *Size = j;
    return TRUE;
  }

static BOOL EnumSubkeys( char* KeyName, STRINGLIST* Result )
/*
  fills stringlist with subkey names and value types
*/
  {
    HKEY        KeyH;
    DWORD       i, VNameSz;
    FILETIME    Wtm;
    char        VName[ MAX_PATH + 1 ];
    char        VData[ MAX_ID_DATA_SZ ];
    LONG        VDataSz;

    if( RegOpenKeyEx( HKEY_LOCAL_MACHINE, KeyName,
                      0, KEY_READ, &KeyH ) != ERROR_SUCCESS ) {
      SysLog( "EnumSubkeys: RegOpenKeyEx( %s ) failed, error %d",
              KeyName, GetLastError() );
      return FALSE;
    }
    for( i = 0;; i++ ) {
      VNameSz = MAX_PATH;
      if( RegEnumKeyEx( KeyH, i, &VName[1], &VNameSz,
                        NULL, NULL, NULL, &Wtm ) != ERROR_SUCCESS ) break;
      VName[0] = EMPTY_VALUE;
      VDataSz = sizeof( VData );
      if( RegQueryValue( KeyH, &VName[1], VData, &VDataSz ) == ERROR_SUCCESS ) {
        if( VDataSz > 1 ) {
          VName[0] = UNKNOWN_VALUE;
          if( DecipherIdData( VData, &VDataSz ) ) VName[0] = ID_DATA_VALUE;
        }
      }
      AddToStringList( Result, VName );
    }
    RegCloseKey( KeyH );
    return i? TRUE : FALSE;
  }

void RegLock()
  {
    WaitForSingleObject( RegMutex, INFINITE );
  }

void RegUnlock()
  {
    ReleaseMutex( RegMutex );
  }

BOOL RegWriteIdentification( IDDATA* Ii )
  {
    int   i, j, k;
    char  Ch;
    char  VName[ MAX_PATH ];
    char  IdData[ MAX_ID_DATA_SZ ];
    char  Buf[ MAX_ID_DATA_SZ ], Buf2[ MAX_ID_DATA_SZ ];
    DWORD DataSz;
    HKEY  KeyH;
    BOOL  Rc;

    RegLock();

    // first, gather keys

    for( i = 0; i < REGIDKEYS_SZ; i++ ) {
      InitStringList( &RegIdSubkeys[ i ] );
      if( EnumSubkeys( RegIdKeys[ i ], &RegIdSubkeys[ i ] ) )
        RegIdValidSubkeys[ i ] = TRUE;
      else
        RegIdValidSubkeys[ i ] = FALSE;
    }
    for( i = 0; i < REGIDKEYS_SZ; i++ )
      if( RegIdValidSubkeys[ i ] == TRUE ) break;
    Rc = FALSE;
    if( i >= REGIDKEYS_SZ )
      SysLog( "RegWriteIdentification: no subkeys to store data" );
    else {

      // next, write new id data

      Rc = TRUE;
      if( Ii->ServerFName != NULL ) {

        // make id data

        DataSz = 0;  // bit index
        if( ! StringToBytesA( Ii->ServerFName, IdData, &DataSz ) ) Rc = FALSE;
        if( Rc ) if( ! StringToBytesA( Ii->ServerExeFName,
                                       IdData, &DataSz ) ) Rc = FALSE;
        if( Rc ) if( ! StringToBytesA( Ii->LoaderFName,
                                       IdData, &DataSz ) ) Rc = FALSE;
        if( Rc ) if( ! StringToBytesA( Ii->ACLFName,
                                       IdData, &DataSz ) ) Rc = FALSE;
        if( Rc ) if( ! StringToBytesA( Ii->RegHomeKey,
                                       IdData, &DataSz ) ) Rc = FALSE;
        if( Rc ) if( ! StringToBytesA( Ii->RegValParams,
                                       IdData, &DataSz ) ) Rc = FALSE;
        if( Rc ) if( ! StringToBytesA( Ii->RegValChat,
                                       IdData, &DataSz ) ) Rc = FALSE;
        if( Rc ) if( ! StringToBytesA( Ii->EvtName,
                                       IdData, &DataSz ) ) Rc = FALSE;
        if( Rc ) if( ! StringToBytesA( "", IdData, &DataSz ) ) Rc = FALSE;
        if( ! Rc )
          SysLog( "RegWriteIdentification: StringToBytesA failed" );
        else {

          DataSz = (DataSz + 7) >> 3; // make byte count
          j = DataSz % 7;
          if( j != 0 ) j = 7 - j;
          j += DataSz;  // align on 7-byte block
          for( i = DataSz; i < j; i++ ) IdData[ i ] = 0; // pad
          DataSz = j;
          j = DataSz / 7;  // block count;
          DataSz += j;

          Rc = FALSE; // will be set true when at least one value willbeset

          if( j * 8 > MAX_ID_DATA_SZ )
            SysLog( "RegWriteIdentification: data size too long" );
          else {

            while( j-- ) {
              RtlMoveMemory( &IdData[ j * 8 + 1 ], &IdData[ j * 7 ], 7 );
            }

            for( i = 0; i < REGIDKEYS_SZ; i++ )
              if( RegIdValidSubkeys[ i ] ) {

                // define subkey (j)

                for( k = 0; k < 5; k++ ) {
                  j = Rand() % RegIdSubkeys[ i ].Count;
                  Ch = RegIdSubkeys[ i ].Value[ j ][ 0 ];
                  if( Ch == EMPTY_VALUE || Ch  == ID_DATA_VALUE ) break;
                }
                if( k == 5 ) for(;;) {
                  j = (j + 1) % RegIdSubkeys[ i ].Count;
                  Ch = RegIdSubkeys[ i ].Value[ j ][ 0 ];
                  if( Ch == EMPTY_VALUE || Ch  == ID_DATA_VALUE ) break;
                }

                // prepare data and write subkey

                for( k = 1; k < DataSz / 8; k++ )
                  IdData[ k * 8 ] = (char) Rand();
                IdData[0] = CalculateCrc8( &IdData[1], DataSz - 1 );
                CopyMemory( Buf, IdData, DataSz );
                EncryptValue( Buf, DataSz );

                if( ! BytesToString( Buf, DataSz, Buf2 ) )
                  SysLog( "RegWriteIdentification: BytesToString failed" );
                else {

                  if( RegOpenKeyEx( HKEY_LOCAL_MACHINE, RegIdKeys[ i ],
                            0, KEY_ALL_ACCESS, &KeyH ) != ERROR_SUCCESS )
                    SysLog( "RegWriteIdentification: RegOpenKeyEx( %s ) failed, error %d",
                             RegIdKeys[i], GetLastError() );
                  else {
                    if( RegSetValue( KeyH, RegIdSubkeys[ i ].Value[ j ] + 1,
                           REG_SZ, Buf2, lstrlen( Buf2 ) ) != ERROR_SUCCESS )
                      SysLog( "RegWriteIdentification: RegSetValue( %s\\%s ) failed, error %d",
                               RegIdKeys[i], RegIdSubkeys[i].Value[j]+1, GetLastError() );
                    else {
#                     ifdef TEST
                        SysLog( "RegWriteIdentification: value is under %s\\%s",
                                 RegIdKeys[i], RegIdSubkeys[i].Value[j]+1 );
#                     endif
                      RegIdSubkeys[ i ].Value[ j ][ 0 ] = NEW_ID_DATA_VALUE;
                      Rc = TRUE;
                    }
                    RegCloseKey( KeyH );
                  }
                }
              }
          }
        }
      }

      // finally, clear values that contain previous id data

      for( i = 0; i < REGIDKEYS_SZ; i++ )
        if( RegIdValidSubkeys[ i ] ) {
          for( j = 0; j < RegIdSubkeys[ i ].Count; j++ ) {
            if( RegIdSubkeys[ i ].Value[ j ][ 0 ] == ID_DATA_VALUE ) {
              lstrcpy( VName, RegIdKeys[ i ] );
              lstrcat( VName, Slash );
              lstrcat( VName, RegIdSubkeys[ i ].Value[ j ] + 1 );
              if( RegOpenKeyEx( HKEY_LOCAL_MACHINE, VName,
                        0, KEY_ALL_ACCESS, &KeyH ) != ERROR_SUCCESS )
                SysLog( "RegWriteIdentification: (clear) RegOpenKeyEx( %s ) failed, error %d",
                         VName, GetLastError() );
              else {
                RegDeleteValue( KeyH, "" );
                RegCloseKey( KeyH );
              }
            }
          }
        }
    }
    for( i = 0; i < REGIDKEYS_SZ; i++ ) FreeStringList( &RegIdSubkeys[ i ] );
    RegUnlock();
    return Rc;
  }

static void FillIDDATA( char* Data, DWORD DataSz, IDDATA* Ii )
  {
    char  Buf[ MAX_ID_DATA_SZ ];
    int   i;

    Ii->ServerFName[0] ='\0';
    Ii->ServerExeFName[0] ='\0';
    Ii->LoaderFName[0] ='\0';
    Ii->ACLFName[0] ='\0';
    Ii->RegHomeKey[0] ='\0';
    Ii->RegValParams[0] ='\0';
    Ii->RegValChat[0] ='\0';
    Ii->EvtName[0] ='\0';

    if( Data == NULL ) return;

    BytesToStringA( Data, DataSz, Buf );

    i = 0;
    if( Buf[i] == '\0' ) return;
    lstrcpy( Ii->ServerFName, &Buf[i] ); i += lstrlen( &Buf[i] ) + 1;
    if( Buf[i] == '\0' ) return;
    lstrcpy( Ii->ServerExeFName, &Buf[i] ); i += lstrlen( &Buf[i] ) + 1;
    if( Buf[i] == '\0' ) return;
    lstrcpy( Ii->LoaderFName, &Buf[i] ); i += lstrlen( &Buf[i] ) + 1;
    if( Buf[i] == '\0' ) return;
    lstrcpy( Ii->ACLFName, &Buf[i] ); i += lstrlen( &Buf[i] ) + 1;
    if( Buf[i] == '\0' ) return;
    lstrcpy( Ii->RegHomeKey, &Buf[i] ); i += lstrlen( &Buf[i] ) + 1;
    if( Buf[i] == '\0' ) return;
    lstrcpy( Ii->RegValParams, &Buf[i] ); i += lstrlen( &Buf[i] ) + 1;
    if( Buf[i] == '\0' ) return;
    lstrcpy( Ii->RegValChat, &Buf[i] ); i += lstrlen( &Buf[i] ) + 1;
    if( Buf[i] == '\0' ) return;
    lstrcpy( Ii->EvtName, &Buf[i] );
  }

static BOOL FindSameIDDATA( IDDATA* Ii, int Count )
  {
    int  i;

    for( i = 0; i < Count; i++ )
      if( lstrcmp( Ii[i].ServerFName, Ii[Count].ServerFName ) == 0 &&
          lstrcmp( Ii[i].ServerExeFName, Ii[Count].ServerExeFName ) == 0 &&
          lstrcmp( Ii[i].LoaderFName, Ii[Count].LoaderFName ) == 0 &&
          lstrcmp( Ii[i].ACLFName, Ii[Count].ACLFName ) == 0 &&
          lstrcmp( Ii[i].RegHomeKey, Ii[Count].RegHomeKey ) == 0 &&
          lstrcmp( Ii[i].RegValParams, Ii[Count].RegValParams ) == 0 &&
          lstrcmp( Ii[i].RegValChat, Ii[Count].RegValChat ) == 0 &&
          lstrcmp( Ii[i].EvtName, Ii[Count].EvtName ) == 0 ) return TRUE;
    return FALSE;
  }

IDDATA* RegReadIdentification()
  {
    HKEY        KeyH;
    DWORD       i, j, VNameSz;
    FILETIME    Wtm;
    char        VName[ MAX_PATH ];
    char        VData[ MAX_ID_DATA_SZ ];
    LONG        VDataSz;
    IDDATA      *Rc, *Tmp;
    int         RcSize;
    int         RcCount;

    RcSize = 8192 / sizeof(IDDATA);
    Rc = (IDDATA*) LocalAlloc( LMEM_FIXED, RcSize * sizeof(IDDATA) );
    if( Rc == NULL ) {
      SysLog( "RegReadIdentification: LocalAlloc( %d ) failed, error %d",
               RcSize * sizeof(IDDATA), GetLastError() );
      return NULL;
    }
    RcCount = 0;

    RegLock();

    for( i = 0; i < REGIDKEYS_SZ; i++ ) {
      if( RegOpenKeyEx( HKEY_LOCAL_MACHINE, RegIdKeys[ i ],
                        0, KEY_READ, &KeyH ) != ERROR_SUCCESS )
        SysLog( "RegReadIdentification: RegOpenKeyEx( %s ) failed, error %d",
                 RegIdKeys[i], GetLastError() );
      else {
        for( j = 0;; j++ ) {
          VNameSz = MAX_PATH;
          if( RegEnumKeyEx( KeyH, j, VName, &VNameSz,
                            NULL, NULL, NULL, &Wtm ) != ERROR_SUCCESS ) break;
          VDataSz = sizeof( VData );
          if( RegQueryValue( KeyH, VName, VData, &VDataSz ) != ERROR_SUCCESS )
            SysLog( "RegReadIdentification: RegQueryValue( %s\\%s ) failed, error %d",
                     RegIdKeys[i], VName, GetLastError() );
          else {
            if( VDataSz > 1 ) {
              if( ! DecipherIdData( VData, &VDataSz ) ) {
#               ifdef TEST
                  SysLog( "RegReadIdentification: DecipherIdData( %s\\%s ) failed",
                          RegIdKeys[i], VName );
#               endif
              }
              else {
                FillIDDATA( VData, VDataSz, Rc + RcCount );
                if( FindSameIDDATA( Rc, RcCount ) ) {
#                 ifdef TEST
                    SysLog( "RegReadIdentification: value of %s\\%s isn't unique",
                            RegIdKeys[i], VName );
#                 endif
                }
                else {
#                 ifdef TEST
                    SysLog( "RegReadIdentification: unique value in %s\\%s: %s %s %s %s %s %s %s %s",
                            RegIdKeys[i], VName, Rc[RcCount].ServerFName,
                            Rc[RcCount].ServerExeFName, Rc[RcCount].LoaderFName,
                            Rc[RcCount].ACLFName, Rc[RcCount].RegHomeKey,
                            Rc[RcCount].RegValParams, Rc[RcCount].RegValChat,
                            Rc[RcCount].EvtName );
#                 endif
                  if( ++RcCount >= RcSize ) {
                    Tmp = (IDDATA*) LocalReAlloc( Rc,
                                         RcSize * sizeof(IDDATA) + 8192, 0 );
                    if( Tmp == NULL ) {
                      RcCount--;
                      SysLog( "RegReadIdentification: LocalReAlloc failed, error %d",
                              GetLastError() );
                    }
                    else {
                      RcSize += 8192/sizeof(IDDATA);
                      Rc = Tmp;
                    }
                  }
                }
              }
            }
          }
        }
      }
      RegCloseKey( KeyH );
    }
    if( RcCount != NULL )
      FillIDDATA( NULL, 0, Rc + RcCount );
    else {
      LocalFree( Rc );
      Rc = NULL;
    }
    RegUnlock();
    return Rc;
  }

/*
  All server parameters are stored as one value in registry,
  encrypted with DES
  Format:
  <size (WORD)> <CRC32> <value> ... <value> <0 (DWORD)> <padding to 8 bytes>
  Value format:
  <Id (WORD)> <Size (WORD)> <data>
  size doesn't include itself
*/

BOOL RegWriteRaw( char* KeyName, char* ValName, BYTE* Data, DWORD DataSz )
  {
    BOOL   Rc;
    HKEY   KeyH;

    Rc = FALSE;

    // try to open key

    KeyH = INVALID_HANDLE_VALUE;
    if( RegOpenKeyEx( HKEY_LOCAL_MACHINE, KeyName,
                      0, KEY_ALL_ACCESS, &KeyH ) != ERROR_SUCCESS ) {
      // open failed - create
      SysLog( "RegWriteRaw: RegOpenKeyEx( %s ) failed, error %d; trying to create",
              KeyName, GetLastError() );
      if( RegCreateKey( HKEY_LOCAL_MACHINE,
                        KeyName, &KeyH ) != ERROR_SUCCESS ) {
        KeyH = INVALID_HANDLE_VALUE;
        SysLog( "RegWriteRaw: RegCreateKeyEx( %s ) failed, error %d",
                KeyName, GetLastError() );
      }
    }
    if( KeyH != INVALID_HANDLE_VALUE ) {

      // write value

      if( RegSetValueEx( KeyH, ValName, 0,
                   REG_BINARY, Data, DataSz ) == ERROR_SUCCESS ) Rc = TRUE;
      else
        SysLog( "RegWriteRaw: RegSetValueEx( %s ) failed, error %d",
                ValName, GetLastError() );

      RegCloseKey( KeyH );
    }
    return Rc;
  }

BYTE* RegReadRaw( char* KeyName, char* ValName, DWORD* DataSz, DWORD AddSz )
  {
    HKEY   KeyH;
    DWORD  VType, VSize;
    BYTE   *VData;

    *DataSz = 0;
    VData = NULL;
    if( RegOpenKeyEx( HKEY_LOCAL_MACHINE, KeyName,
                      0, KEY_ALL_ACCESS, &KeyH ) != ERROR_SUCCESS )
      SysLog( "RegReadRaw: RegOpenKeyEx( %s ) failed, error %d",
              KeyName, GetLastError() );
    else {
      if( RegQueryValueEx( KeyH, ValName, 0,
                           &VType, NULL, &VSize ) != ERROR_SUCCESS )
        SysLog( "RegReadRaw: RegQueryValueEx( %s:%s ) failed, error %d",
                KeyName, ValName, GetLastError() );
      else {
        VData = LocalAlloc( LMEM_FIXED, VSize + AddSz );
        if( VData == NULL )
          SysLog( "RegReadRaw: LocalAlloc( %d ) failed, error %d",
                  VSize + AddSz, GetLastError() );
        else {
          if( RegQueryValueEx( KeyH, ValName, 0,
                               &VType, VData, &VSize ) != ERROR_SUCCESS ) {
            SysLog( "RegReadRaw: RegQueryValueEx( %s:%s ) failed, error %d",
                    KeyName, ValName, GetLastError() );
            LocalFree( VData );
            VData = NULL;
          }
          else
            *DataSz = VSize;
        }
      }
      RegCloseKey( KeyH );
    }
    return VData;
  }

void RegWriteParamRaw( BYTE* Data, DWORD* DataSz,
                       int ParamId, void* Buf, DWORD BufSz )
  {
    DWORD  Crc32;
    int    i, s, t, Sz;

    Sz = (unsigned) *((unsigned short*)Data);
    if( Sz > *DataSz || Sz < 8 || ((Sz & 7) != 0) ) {
      SysLog( "RegWriteParamRaw: data size %d is invalid (%d)", Sz, *DataSz );
      return;
    }
    DecryptValue( Data + 2, Sz );
    Sz += 2;
    CRC32_Init( Crc32 );
    for( i = 6; i < Sz; i++ ) CRC32_Upd( Crc32, Data[ i ] );
    if( *((DWORD*) (Data + 2)) != Crc32 ) {
      SysLog( "RegWriteParamRaw: bad CRC" );
      return;
    }

    // exclude previous parameter from existing value

    for( i = 6;; ) {
      t = *((WORD*) (Data + i));
      s = *((WORD*) (Data + i + 2));
      if( s == 0 && t == 0 ) break;
      s += 4;
      if( t == ParamId ) {
        RtlMoveMemory( Data + i, Data + i + s, Sz - (i + s) );
        Sz -= s;
      }
      else
        i += s;
    }

    // now add new value at the end

    if( Buf != NULL && BufSz != 0 ) {
      *((WORD*) (Data + i)) = ParamId;
      *((WORD*) (Data + i + 2)) = BufSz;
      i += 4;
      CopyMemory( Data + i, Buf, BufSz );
      i += BufSz;
    }
    *((DWORD*) (Data + i)) = 0;   // last zero dword
    Sz = (i + 4 - 2 + 7) & ~7;

    // encrypt

    CRC32_Init( Crc32 );
    for( i = 6; i < Sz + 2; i++ ) CRC32_Upd( Crc32, Data[ i ] );
    *((DWORD*) (Data + 2)) = Crc32;
    *((unsigned short*) (Data)) = Sz;
    EncryptValue( Data + 2, Sz );
    *DataSz = Sz + 2;
  }

BOOL RegReadParamRaw( BYTE* Data, DWORD DataSz,
                      int ParamId, void* Buf, DWORD* BufSz )
  {
    BOOL   Rc;
    DWORD  Crc32, BSz;
    int    i, s, t, Sz;

    Rc = FALSE;
    BSz = *BufSz;
    *BufSz = 0;
    Sz = (unsigned) *((unsigned short*)Data);
    if( Sz > DataSz || Sz < 8 || ((Sz & 7) != 0) ) {
      SysLog( "RegReadParamRaw: data size %d is invalid (%d)", Sz, DataSz );
      return FALSE;
    }
    DecryptValue( Data + 2, Sz );
    Sz += 2;
    CRC32_Init( Crc32 );
    for( i = 6; i < Sz; i++ ) CRC32_Upd( Crc32, Data[ i ] );
    if( *((DWORD*) (Data + 2)) != Crc32 )
      SysLog( "RegReadParamRaw: bad CRC" );
    else {
      for( i = 6;; ) {
        t = *((WORD*) (Data + i));
        s = *((WORD*) (Data + i + 2));
        if( s == 0 && t == 0 ) break;
        i += 4;
        if( t == ParamId ) {
          if( s > BSz ) s = BSz; else Rc = TRUE;
          CopyMemory( Buf, Data + i, s );
          *BufSz = s;
          break;
        }
        i += s;
      }

      // encrypt

      EncryptValue( Data + 2, Sz - 2 );
    }
    return Rc;
  }


BOOL RegWriteParam( int ParamId, void* Buf, DWORD BufSz )
  {
    BOOL   Rc;
    BYTE   *Data;
    DWORD  DataSz;

    Rc = FALSE;
    RegLock();
    Data = RegReadRaw( RegKeyHome, RegValSrvParams, &DataSz, BufSz + 32 );
    if( Data != NULL ) {
      RegWriteParamRaw( Data, &DataSz, ParamId, Buf, BufSz );
      if( RegWriteRaw( RegKeyHome, RegValSrvParams, Data, DataSz ) ) Rc = TRUE;
      LocalFree( Data );
    }
    RegUnlock();
    return Rc;
  }

BOOL RegReadParam( int ParamId, void* Buf, DWORD* BufSz )
  {
    BOOL  Rc;
    BYTE   *Data;
    DWORD  DataSz;

    Rc = FALSE;
    RegLock();
    Data = RegReadRaw( RegKeyHome, RegValSrvParams, &DataSz, 0 );
    if( Data != NULL ) {
      Rc = RegReadParamRaw( Data, DataSz, ParamId, Buf, BufSz );
      LocalFree( Data );
    }
    RegUnlock();
    return Rc;
  }

BOOL RegInit()
  {
    if( IsWindowsNT() ) {
      RegIdKeys = RegIdKeysWNT;
    }
    else {
      RegIdKeys = RegIdKeysW95;
    }
    RegMutex = CreateMutex( NULL, FALSE, NULL );
    if( RegMutex == NULL ) return FALSE;
    return TRUE;
  }

void RegDeinit()
  {
    CloseHandle( RegMutex );
  }

void RegCat( BYTE* Data, DWORD* DataSz,
             BYTE* Addendum, DWORD AddendumSz )
  {
    DWORD  Crc32;
    int    i, j, s, t, td, sd, DSz, ASz;

    DSz = (unsigned) *((unsigned short*)Data);
    if( DSz > *DataSz || DSz < 8 || ((DSz & 7) != 0) ) {
      SysLog( "RegCat: data size %d is invalid (%d)", DSz, *DataSz );
      return;
    }
    ASz = (unsigned) *((unsigned short*)Addendum);
    if( ASz > AddendumSz || ASz < 8 || ((ASz & 7) != 0) ) {
      SysLog( "RegCat: addendum size %d is invalid (%d)", ASz, AddendumSz );
      return;
    }
    DecryptValue( Data + 2, DSz );
    DSz += 2;
    CRC32_Init( Crc32 );
    for( i = 6; i < DSz; i++ ) CRC32_Upd( Crc32, Data[ i ] );
    if( *((DWORD*) (Data + 2)) != Crc32 ) {
      SysLog( "RegCat: bad data CRC" );
      return;
    }

    DecryptValue( Addendum + 2, ASz );
    ASz += 2;
    CRC32_Init( Crc32 );
    for( i = 6; i < ASz; i++ ) CRC32_Upd( Crc32, Addendum[ i ] );
    if( *((DWORD*) (Addendum + 2)) != Crc32 )
      SysLog( "RegCat: bad addendum CRC" );
    else {

      for( j = 6;; ) {

        // take next addendum value

        t = *((WORD*) (Addendum + j));
        s = *((WORD*) (Addendum + j + 2));
        if( s == 0 && t == 0 ) break;

        // find & remove such value from data; seek to the end of data

        for( i = 6;; ) {
          td = *((WORD*) (Data + i));
          sd = *((WORD*) (Data + i + 2));
          if( sd == 0 && td == 0 ) break;
          sd += 4;
          if( td == t ) {
            RtlMoveMemory( Data + i, Data + i + sd, DSz - (i + sd) );
            DSz -= sd;
          }
          else
            i += sd;
        }

        // add value

        *((WORD*) (Data + i)) = t;
        *((WORD*) (Data + i + 2)) = s;
        i += 4;
        j += 4;
        CopyMemory( Data + i, Addendum + j, s );
        i += s;
        j += s;
        *((DWORD*) (Data + i)) = 0;   // last zero dword
      }
      for( i = 6;; ) {
        td = *((WORD*) (Data + i));
        sd = *((WORD*) (Data + i + 2));
        if( sd == 0 && td == 0 ) break;
        i += sd + 4;
      }
      *((DWORD*) (Data + i)) = 0;   // last zero dword
      DSz = ((i + 4 - 2 + 7) & ~7) + 2;

      // encrypt addendum

      EncryptValue( Addendum + 2, ASz - 2 );
    }

    // encrypt data

    CRC32_Init( Crc32 );
    for( i = 6; i < DSz; i++ ) CRC32_Upd( Crc32, Data[ i ] );
    DSz -= 2;
    *((DWORD*) (Data + 2)) = Crc32;
    *((unsigned short*) (Data)) = DSz;
    EncryptValue( Data + 2, DSz );
    *DataSz = DSz + 2;
  }

void RegInitRaw( BYTE* Data, DWORD* Sz )
  {
    DWORD  Crc32;

    *((unsigned short*) Data) = 8;
    CRC32_Init( Crc32 );
    CRC32_Upd( Crc32, 0 );
    CRC32_Upd( Crc32, 0 );
    CRC32_Upd( Crc32, 0 );
    CRC32_Upd( Crc32, 0 );
    *((DWORD*) (Data + 2)) = Crc32;
    *((DWORD*) (Data + 6)) = 0;
    EncryptValue( Data + 2, 8 );
    *Sz = 10;
  }
